(function () {
  if (window.__employeeTrackerClickListener) {
    return;
  }
  window.__employeeTrackerClickListener = true;

  let pendingClicks = 0;
  let lastSent = Date.now();
  const SEND_INTERVAL_MS = 750;

  const flushClicks = () => {
    if (!pendingClicks) {
      return;
    }

    const payload = { action: 'click_tracker_increment', count: pendingClicks };
    pendingClicks = 0;
    lastSent = Date.now();
    try {
      chrome.runtime.sendMessage(payload, () => chrome.runtime.lastError && console.debug('clickTracker sendMessage error:', chrome.runtime.lastError.message));
    } catch (error) {
      console.debug('clickTracker failed to send clicks:', error);
    }
  };

  const scheduleFlush = () => {
    if (Date.now() - lastSent >= SEND_INTERVAL_MS) {
      flushClicks();
    }
  };

  const handlePointerDown = () => {
    pendingClicks += 1;
    if (pendingClicks >= 10) {
      flushClicks();
    } else {
      scheduleFlush();
    }
  };

  window.addEventListener('pointerdown', handlePointerDown, true);
  window.addEventListener('mousedown', handlePointerDown, true);

  window.addEventListener('blur', flushClicks, true);
  window.addEventListener('visibilitychange', () => {
    if (document.visibilityState === 'hidden') {
      flushClicks();
    }
  }, true);
  window.addEventListener('beforeunload', flushClicks, { once: true });
})();
