// Injected script for palal.app
// This runs in the page context to provide extension communication bridge

// Create a bridge for web pages to communicate with extension
window.extensionBridge = {
  sendMessage: function(message, callback) {
    window.postMessage(message, 'https://palal.app');
    
    // Listen for response
    if (callback) {
      const listener = (event) => {
        if (event.origin === 'https://palal.app' && 
            event.data.type === 'FROM_EXTENSION' &&
            event.data.action === message.action) {
          window.removeEventListener('message', listener);
          callback(event.data.response);
        }
      };
      window.addEventListener('message', listener);
    }
  }
};

// Also expose chrome.runtime for compatibility
if (!window.chrome) {
  window.chrome = {};
}
if (!window.chrome.runtime) {
  window.chrome.runtime = {
    sendMessage: function(message, callback) {
      window.extensionBridge.sendMessage(message, callback);
    }
  };
}

console.log('Extension bridge initialized');
